# Confronting Implicit Bias and Microaggression
## 2.5 hour workshop

## Objectives:

Using an intersectional lens, students will develop an understanding of what implicit bias is, how it may impact them individually, and how it can impact our community. They will develop an understanding of microaggressions and how our biases can help create these destructive interactions. Finally, they will explore how they can use this awareness to intervene in microaggressive interactions. 

## Part 1: Building Our Container (About 15 minutes)

* Draw a large jar or box on the whiteboard to write over. Ask the group, "What makes you feel safe during uncomfortable or difficult conversations?" "What will hold us together as a community during this workshop, rather than break us down?"
 *This is an alternative to writing "ground rules." This will sometimes branch into a larger conversation about how we want to handle ignorant or potentially hurtful statements. Let it happen.*

## Part 2: Reviewing Intersectionality (About 20 minutes)

* "I want to start by returning to the concept of intersectionality, which we touched on in our Jumpstart Social Justice work." Don't define the term for them.
* Break into 6 small groups of about 4 students and give them the guiding questions 1.) What is Intersectionality? Create a working definition for your group. 2.) Why are we starting with it?
* Give each group [this comic](https://stavvers.files.wordpress.com/2013/04/301969_452534864833450_34072018_n.png) and [this comic](https://s-media-cache-ak0.pinimg.com/564x/27/fc/3b/27fc3bd4e00748d58ddd7079073a75ac.jpg) to guide the conversation.
* Return to large group and ask for groups to share their definitions. Help guide the group to a collective understanding of the term after hearing several groups' definitions. Ask for groups to share their thoughts about why we're starting with "intersectionality." Talk about the multiplicity of identity within any group and all the types of identities we bring to Ada besides our gender, some of which carry privilege and some of which may culturally marginalize us.

## Part 3: Implicit Bias (about 45 min)

* "So, if it was as easy as recognizing our intersectionality and then automatically having identity-inclusive space, we would be done. Now we’re going to talk about some of the roadblocks in working towards that intersectional, inclusive community. "
* Play [Immaculate Perception Ted Talk](https://www.youtube.com/watch?v=9VGbwNI6Ssk) until 6:30.
* Pause video and give instruction for everyone to complete an [Implicit Association Test](https://implicit.harvard.edu/implicit/takeatest.html). "This can be an emotional experience, you aren’t going to be asked to share your results, and we’ll take a little break after the rest of the video. Please open the slack link I just sent you and start the test. Let me know if you have any problems.”
* Resume video.

15 minute break

## Part 4: Microaggressions (about 60 min)

* “Now we’re going to look at what some of the impact of implicit bias can be on our interactions and communities, and how we can start addressing that at Ada.”
* Use [This Prezzi](https://prezi.com/x851tgvzcykz/leading-by-example-combating-microaggressions/). *Skip "Community" clip, play the "Comedy Week" video*
* Split into 6 groups of 4 again. Pass out these three scenarios, one to each group. Give about 15 minutes for groups to discuss how they would handle these scenarios.
  1. Scenario: An Adie has informed everyone that they use gender neutral pronouns and would like to be referred to as "they." Shortly following this, you hear another student address them as "she." What do you do?
  2. Scenario: You are working on a group project with other Adies. One is white, one is latina. You hear the white student commenting that she's "surprised at how articulate" the latina student is. What do you do?
  3. Scenario: In conversation with a group of Adies, you accidentally call an Asian classmate by the name of a different Asian Adie. She immediately responds, "That felt like a microaggression and I'm hurt that you confused me with someone else of my race." How do you respond?
* Return to the large group and ask each group to share their scenario and how they would handle it. Each scenario will usually branch into a bigger conversation about how to handle oppressive behavior at Ada and how to have difficult conversations with people on all sides of a microaggression.

## Part 5: Return to Our Container (about 10 min)

* Revisit the container and ask the group how we did. Anything we would add or change with hindsight? Take a picture of the container to save for the next workshop.
* Get any final thoughts and let everyone know we will continue this work at our "Creating Inclusive Community" workshop.
